/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class Main {
    public static boolean useJline = true;
    public static boolean useConsole = true;

    public static OptionSet main(String[] args) {
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Main.asList(new String[]{"?", "help"}), "Show the help");
                this.acceptsAll(Main.asList(new String[]{"c", "config"}), "Properties file to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("server.properties"), (Object[])new File[0]).describedAs("Properties file");
                this.acceptsAll(Main.asList(new String[]{"P", "plugins"}), "Plugin directory to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("plugins"), (Object[])new File[0]).describedAs("Plugin directory");
                this.acceptsAll(Main.asList(new String[]{"h", "host", "server-ip"}), "Host to listen on").withRequiredArg().ofType(String.class).describedAs("Hostname or IP");
                this.acceptsAll(Main.asList(new String[]{"W", "world-dir", "universe", "world-container"}), "World container").withRequiredArg().ofType(File.class).describedAs("Directory containing worlds");
                this.acceptsAll(Main.asList(new String[]{"w", "world", "level-name"}), "World name").withRequiredArg().ofType(String.class).describedAs("World name");
                this.acceptsAll(Main.asList(new String[]{"p", "port", "server-port"}), "Port to listen on").withRequiredArg().ofType(Integer.class).describedAs("Port");
                this.acceptsAll(Main.asList(new String[]{"o", "online-mode"}), "Whether to use online authentication").withRequiredArg().ofType(Boolean.class).describedAs("Authentication");
                this.acceptsAll(Main.asList(new String[]{"s", "size", "max-players"}), "Maximum amount of players").withRequiredArg().ofType(Integer.class).describedAs("Server size");
                this.acceptsAll(Main.asList(new String[]{"d", "date-format"}), "Format of the date to display in the console (for log entries)").withRequiredArg().ofType(SimpleDateFormat.class).describedAs("Log date format");
                this.acceptsAll(Main.asList(new String[]{"log-pattern"}), "Specfies the log filename pattern").withRequiredArg().ofType(String.class).defaultsTo((Object)"server.log", (Object[])new String[0]).describedAs("Log filename");
                this.acceptsAll(Main.asList(new String[]{"log-limit"}), "Limits the maximum size of the log file (0 = unlimited)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]).describedAs("Max log size");
                this.acceptsAll(Main.asList(new String[]{"log-count"}), "Specified how many log files to cycle through").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Log count");
                this.acceptsAll(Main.asList(new String[]{"log-append"}), "Whether to append to the log file").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]).describedAs("Log append");
                this.acceptsAll(Main.asList(new String[]{"log-strip-color"}), "Strips color codes from log file");
                this.acceptsAll(Main.asList(new String[]{"b", "bukkit-settings"}), "File for bukkit settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("bukkit.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList(new String[]{"C", "commands-settings"}), "File for command settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("commands.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList(new String[]{"nojline"}), "Disables jline and emulates the vanilla console");
                this.acceptsAll(Main.asList(new String[]{"noconsole"}), "Disables the console");
                this.acceptsAll(Main.asList(new String[]{"v", "version"}), "Show the CraftBukkit Version");
                this.acceptsAll(Main.asList(new String[]{"demo"}), "Demo mode");
                this.acceptsAll(Main.asList(new String[]{"mixin"}), "This argument is needed for proper Mixin Framework work in the test env");
                this.acceptsAll(Main.asList(new String[]{"S", "spigot-settings"}), "File for spigot settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("spigot.yml"), (Object[])new File[0]).describedAs("Yml file");
            }
        };
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex2) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex2.getLocalizedMessage());
        }
        if (options == null || options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException ex3) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex3);
            }
        } else {
            String path = new File(".").getAbsolutePath();
            if (path.contains("!") || path.contains("+")) {
                System.err.println("Cannot run server in a directory with ! or + in the pathname. Please rename the affected folders and try again.");
                return null;
            }
            try {
                if (options.has("nojline")) {
                    System.setProperty("terminal.jline", "false");
                    useJline = false;
                }
                if (options.has("noconsole")) {
                    useConsole = false;
                    useJline = false;
                    System.setProperty("terminal.jline", "false");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return options;
        }
        return null;
    }

    private static List<String> asList(String ... params) {
        return Arrays.asList(params);
    }
}

